/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.xunitxml;

import io.qameta.allure.Reader;
import io.qameta.allure.context.RandomUidContext;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.ResultsVisitor;
import io.qameta.allure.entity.LabelName;
import io.qameta.allure.entity.Parameter;
import io.qameta.allure.entity.Status;
import io.qameta.allure.entity.TestResult;
import io.qameta.allure.entity.Time;
import io.qameta.allure.parser.XmlElement;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XunitXmlPlugin
implements Reader {
    private static final Logger LOGGER = LoggerFactory.getLogger(XunitXmlPlugin.class);
    public static final String XUNIT_RESULTS_FORMAT = "xunit";
    private static final BigDecimal MULTIPLICAND = new BigDecimal(1000);
    private static final String ASSEMBLIES_ELEMENT_NAME = "assemblies";
    private static final String ASSEMBLY_ELEMENT_NAME = "assembly";
    private static final String COLLECTION_ELEMENT_NAME = "collection";
    private static final String TEST_ELEMENT_NAME = "test";
    private static final String FAILURE_ELEMENT_NAME = "failure";
    private static final String MESSAGE_ELEMENT_NAME = "message";
    private static final String STACK_TRACE_ELEMENT_NAME = "stack-trace";
    private static final String OUTPUT_ELEMENT_NAME = "output";
    private static final String TRAIT_ELEMENT_NAME = "trait";
    private static final String TRAITS_ELEMENT_NAME = "traits";
    private static final String FRAMEWORK_ATTRIBUTE_NAME = "test-framework";
    private static final String METHOD_ATTRIBUTE_NAME = "method";
    private static final String TYPE_ATTRIBUTE_NAME = "type";
    private static final String RESULT_ATTRIBUTE_NAME = "result";
    private static final String TIME_ATTRIBUTE_NAME = "time";
    private static final String NAME_ATTRIBUTE_NAME = "name";
    private static final String VALUE_ATTRIBUTE_NAME = "value";

    public void readResults(Configuration configuration, ResultsVisitor visitor, Path directory) {
        RandomUidContext context = (RandomUidContext)configuration.requireContext(RandomUidContext.class);
        XunitXmlPlugin.listResults(directory).forEach(result -> this.parseAssemblies((Path)result, context, visitor));
    }

    private void parseAssemblies(Path parsedFile, RandomUidContext context, ResultsVisitor visitor) {
        try {
            LOGGER.debug("Parsing file {}", (Object)parsedFile);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(parsedFile.toFile());
            XmlElement assembliesElement = new XmlElement(document.getDocumentElement());
            String elementName = assembliesElement.getName();
            if (!ASSEMBLIES_ELEMENT_NAME.equals(elementName)) {
                LOGGER.debug("{} is not a valid XUnit xml file. Unknown root element {}", (Object)parsedFile, (Object)elementName);
                return;
            }
            assembliesElement.get(ASSEMBLY_ELEMENT_NAME).forEach(element -> this.parseAssembly((XmlElement)element, context, visitor));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOGGER.error("Could not parse file {}: {}", (Object)parsedFile, (Object)e);
        }
    }

    private void parseAssembly(XmlElement assemblyElement, RandomUidContext context, ResultsVisitor visitor) {
        String framework = this.getFramework(assemblyElement);
        assemblyElement.get(COLLECTION_ELEMENT_NAME).forEach(element -> this.parseCollection((XmlElement)element, framework, context, visitor));
    }

    private void parseCollection(XmlElement collectionElement, String framework, RandomUidContext context, ResultsVisitor visitor) {
        collectionElement.get(TEST_ELEMENT_NAME).forEach(element -> this.parseTest((XmlElement)element, framework, context, visitor));
    }

    private void parseTest(XmlElement testElement, String framework, RandomUidContext context, ResultsVisitor visitor) {
        Optional<String> fullName = Optional.ofNullable(testElement.getAttribute(NAME_ATTRIBUTE_NAME));
        String className = testElement.getAttribute(TYPE_ATTRIBUTE_NAME);
        String methodName = testElement.getAttribute(METHOD_ATTRIBUTE_NAME);
        TestResult result = new TestResult();
        result.setUid((String)context.getValue().get());
        result.setName(methodName);
        result.setStatus(this.getStatus(testElement));
        result.setTime(this.getTime(testElement));
        fullName.ifPresent(arg_0 -> ((TestResult)result).setFullName(arg_0));
        fullName.ifPresent(arg_0 -> ((TestResult)result).setHistoryId(arg_0));
        this.getStatusMessage(testElement).ifPresent(arg_0 -> ((TestResult)result).setStatusMessage(arg_0));
        this.getStatusTrace(testElement).ifPresent(arg_0 -> ((TestResult)result).setStatusTrace(arg_0));
        this.getParameters(testElement).ifPresent(arg_0 -> ((TestResult)result).setParameters(arg_0));
        result.addLabelIfNotExists(LabelName.RESULT_FORMAT, XUNIT_RESULTS_FORMAT);
        if (Objects.nonNull(className)) {
            result.addLabelIfNotExists(LabelName.SUITE, className);
            result.addLabelIfNotExists(LabelName.TEST_CLASS, className);
            result.addLabelIfNotExists(LabelName.PACKAGE, className);
        }
        if (Objects.nonNull(framework)) {
            result.addLabelIfNotExists(LabelName.FRAMEWORK, framework);
        }
        visitor.visitTestResult(result);
    }

    private Status getStatus(XmlElement testElement) {
        String status = testElement.getAttribute(RESULT_ATTRIBUTE_NAME);
        if ("Pass".equalsIgnoreCase(status)) {
            return Status.PASSED;
        }
        if ("Fail".equalsIgnoreCase(status)) {
            return Status.FAILED;
        }
        if ("Skip".equalsIgnoreCase(status)) {
            return Status.SKIPPED;
        }
        return Status.UNKNOWN;
    }

    private Optional<String> getStatusMessage(XmlElement testElement) {
        Optional<String> message = testElement.getFirst(FAILURE_ELEMENT_NAME).flatMap(failure -> failure.getFirst(MESSAGE_ELEMENT_NAME)).map(XmlElement::getValue);
        Optional<String> output = testElement.getFirst(OUTPUT_ELEMENT_NAME).map(XmlElement::getValue);
        if (message.isPresent() && output.isPresent()) {
            return Optional.of(String.format("%s%n%s", message.get(), output.get()));
        }
        if (message.isPresent()) {
            return message;
        }
        return output;
    }

    private Optional<String> getStatusTrace(XmlElement testElement) {
        return testElement.getFirst(FAILURE_ELEMENT_NAME).flatMap(failure -> failure.getFirst(STACK_TRACE_ELEMENT_NAME)).map(XmlElement::getValue);
    }

    private Optional<List<Parameter>> getParameters(XmlElement testElement) {
        return testElement.getFirst(TRAITS_ELEMENT_NAME).map(traits -> traits.get(TRAIT_ELEMENT_NAME)).map(Collection::stream).map(stream -> stream.map(this::getParameter)).map(stream -> stream.collect(Collectors.toList()));
    }

    private Parameter getParameter(XmlElement traitElement) {
        String name = traitElement.getAttribute(NAME_ATTRIBUTE_NAME);
        String value = traitElement.getAttribute(VALUE_ATTRIBUTE_NAME);
        return new Parameter().setName(name).setValue(value);
    }

    private String getFramework(XmlElement assemblyElement) {
        return assemblyElement.getAttribute(FRAMEWORK_ATTRIBUTE_NAME);
    }

    private Time getTime(XmlElement testElement) {
        if (testElement.containsAttribute(TIME_ATTRIBUTE_NAME)) {
            try {
                long duration = BigDecimal.valueOf(testElement.getDoubleAttribute(TIME_ATTRIBUTE_NAME)).multiply(MULTIPLICAND).longValue();
                return new Time().setDuration(Long.valueOf(duration));
            }
            catch (Exception e) {
                LOGGER.debug("Could not parse time attribute for element test", (Throwable)e);
            }
        }
        return new Time();
    }

    private static List<Path> listResults(Path directory) {
        ArrayList<Path> result = new ArrayList<Path>();
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            return result;
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory, "*.xml");){
            for (Path path : directoryStream) {
                if (Files.isDirectory(path, new LinkOption[0])) continue;
                result.add(path);
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not read data from {}: {}", (Object)directory, (Object)e);
        }
        return result;
    }
}

