package com.lemon.cases;

import io.qameta.allure.Description;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;
import java.util.Arrays;

/**
 * @program: RaysLearn
 * @description: 支付
 * @author: ray
 * @create: 2023-03-14 09:58
 **/
public class PayCase extends BaseCase {
    private CookieStore cookie;
    private CookieStore cooki;

    // 线上环境-RAYS获取商户号支付信息
    @Test(dataProvider = "datas0")
    @Description("获取商户号支付信息")
    public void testPay(int id, String casename, String url, String expectValue) throws Exception {
//        String cookie = "checkUserInfo=userId=84; userInfo=officialAccountsId=997&channelId=1362&wechatUserId=182833248&hasSnapsis=0&userType=REGULAR&bookId=12567110&adviserId=1362&sceneId=3930381&sourceType=QRCODE&spreadType=0";
        // 创建get请求
        HttpGet get = new HttpGet(url);
        // 传参为JSON类型
        get.setHeader("Content-Type", "application/json");
        // 创建一个client
        DefaultHttpClient client = new DefaultHttpClient();
        // 将cookie信息添加到header中
        client.setCookieStore(this.cookie);
        // 执行get请求，并使用response来存放执行后返回的响应内容
        HttpResponse response = client.execute(get);
        Header[] header = response.getAllHeaders(); // 响应头
        System.out.print("id:" + id + "\n"+ "casename:" + casename+ "\n");
        System.out.print("响应头信息:::" + Arrays.toString(header) + "\n");
        int status = response.getStatusLine().getStatusCode();
        System.out.print("状态码:::" + status + "\n");
        HttpEntity entity = response.getEntity(); // 响应体
        String body = EntityUtils.toString(entity);
        System.out.print("预期结果: " + expectValue+ "\n");
        System.out.print("响应结果: " + body+ "\n");
        Boolean assertResponseFlag = assertRespon(expectValue, body);
        String assertContent = (assertResponseFlag) ? "Pass" : "Fail";
        System.out.print("assertContent:"+assertContent);
        Assert.assertEquals(assertContent, "Pass");
    }

    @DataProvider(name = "datas0")
    public Object[][] datas0() {
        //Object[m][n] m代表执行次数，n代表参数个数
        Object[][] datas = {
//                {1, "RAYS自跳RAYS", "https://weixin23.5rs.me/channelcenter/v1.0/accountSetting/getOpreateManageInfo?officialAccountsId=23", "{\"errCode\":0,\"message\":\"操作成功！\",\"data\":{\"officialAccountsId\":23,\"payAccounts\":23,\"officialAccountsName\":\"书童小睿\",\"domain\":\"weixin23.5rs.me\",\"payDomain\":\"weixin23.5rs.me\",\"manageDomain\":\"wechat22.5rs.me\",\"icon\":\"https://oss.5rs.me/oss/uploadfe/png/942c1c8f4f2a7bc81f82743c48bbaa1a.png\",\"description\":\"属于你的双十一狂欢会\",\"iosAlipayOpen\":0,\"payMchId\":\"1639325477\",\"currentPagePay\":0,\"phoneAuthOpen\":0,\"payMethod\":1,\"developerAppId\":\"wx833c9707dcafe1c0\"}}"},
//                {2, "蓝海生态跳RAYS", "https://weixin28.5rs.me/channelcenter/v1.0/accountSetting/getOpreateManageInfo?officialAccountsId=28", "{\"errCode\":0,\"message\":\"操作成功！\",\"data\":{\"officialAccountsId\":28,\"payAccounts\":23,\"officialAccountsName\":\"RAYS蓝海生态\",\"domain\":\"weixin28.5rs.me\",\"payDomain\":\"weixin23.5rs.me\",\"manageDomain\":\"wechat22.5rs.me\",\"icon\":\"https://oss.5rs.me/oss/uploadfe/jpg/bbee8ff1fe52e5c58ab669d937a7f406.jpg\",\"description\":\"RAYS，给你别致的读书体验\",\"iosAlipayOpen\":0,\"payMchId\":\"1639325477\",\"currentPagePay\":0,\"phoneAuthOpen\":0,\"payMethod\":1,\"developerAppId\":\"wxb700ce984a880a88\"}}"},
//                {3, "上海教育跳RAYS", "https://weixin65750.rayswdcb.com/channelcenter/v1.0/accountSetting/getOpreateManageInfo?officialAccountsId=65750", "{\"errCode\":0,\"message\":\"操作成功！\",\"data\":{\"officialAccountsId\":65750,\"payAccounts\":23,\"officialAccountsName\":\"上海教育出版社有限公司\",\"domain\":\"weixin65750.rayswdcb.com\",\"payDomain\":\"weixin23.5rs.me\",\"manageDomain\":\"wechat75903.rayswang.com\",\"icon\":\"https://oss.5rs.me/oss/uploadfe/jpg/a7684e17ab41c8e43e7576e7321b8a77.jpg\",\"description\":\"上海教育出版社有限公司\",\"iosAlipayOpen\":0,\"payMchId\":\"1639325477\",\"currentPagePay\":0,\"phoneAuthOpen\":0,\"payMethod\":1,\"developerAppId\":\"wx25299e936b90c7d5\"}}"},
                {4, "小蓝书跳小蓝书", "https://weixin65842.rayshbjy.com/channelcenter/v1.0/accountSetting/getOpreateManageInfo?officialAccountsId=65842", "{\"errCode\":0,\"message\":\"操作成功！\",\"data\":{\"officialAccountsId\":65842,\"payAccounts\":65842,\"officialAccountsName\":\"小蓝书高中生服务平台\",\"domain\":\"weixin65842.rayshbjy.com\",\"payDomain\":\"weixin65842.rayshbjy.com\",\"manageDomain\":\"wechat65842.rayshbjy.com\",\"icon\":\"https://oss.5rs.me/oss/uploadfe/jpg/3c1aa1fa65912a1a2673bc6ca05039d2.jpg\",\"description\":\"小蓝书携手一线教研专家，为全国高中生提供一站式服务：教育资讯、新高考选科工具，优质图书、课程推荐，专家、学霸交流等。\",\"iosAlipayOpen\":0,\"payMchId\":\"1521882781\",\"currentPagePay\":0,\"phoneAuthOpen\":0,\"payMethod\":1,\"developerAppId\":\"wxe8292f5327e2dda9\"}}"},
                {5, "新世纪跳新世纪", "https://weixin65700.rayscjsn.com/channelcenter/v1.0/accountSetting/getOpreateManageInfo?officialAccountsId=65700", "{\"errCode\":0,\"message\":\"操作成功！\",\"data\":{\"officialAccountsId\":65700,\"payAccounts\":65998,\"officialAccountsName\":\"广东新世纪出版社有限公司\",\"domain\":\"weixin65700.rayscjsn.com\",\"payDomain\":\"wechat65700.rayscjsn.com\",\"manageDomain\":\"wechat65700.rayscjsn.com\",\"icon\":\"https://oss.5rs.me/resources/jpg/j5zxhrw9N3EqbCR7oVFTHaP4W2DByZmg.jpg\",\"iosAlipayOpen\":0,\"payMchId\":\"1594177521\",\"currentPagePay\":0,\"phoneAuthOpen\":0,\"payMethod\":1,\"developerAppId\":\"wx3006f8db8a34cf9d\"}}"}
        };
        return datas;
    }

    // 线上环境-小睿伴学获取支付商户号信息
    @Test(dataProvider = "datas1")
    @Description("获取商户号支付信息")
    public void testRaysPay(int id, String casename, String url, String expectValue) throws Exception {
        String cooki = "userInfo=wechatUserId=183639793&officialAccountsId=50687";
        // 创建get请求
        HttpGet get = new HttpGet(url);
        // 传参为JSON类型
        get.setHeader("Content-Type", "application/json");
        // 创建一个client
        DefaultHttpClient client = new DefaultHttpClient();
        // 将cookie信息添加到header中
        client.setCookieStore(this.cooki);
        // 执行get请求，并使用response来存放执行后返回的响应内容
        HttpResponse response = client.execute(get);
        Header[] header = response.getAllHeaders(); // 响应头
        System.out.print("id:" + id + "casename:" + casename);
        System.out.print("响应头信息： " + Arrays.toString(header) + "\n");
        int status = response.getStatusLine().getStatusCode();
        System.out.print("状态码: " + status + "\n");
        HttpEntity entity = response.getEntity(); // 响应体
        String body = EntityUtils.toString(entity);
        System.out.print("预期结果: " + expectValue+ "\n");
        System.out.print("响应结果: " + body+ "\n");
        Boolean assertResponseFlag = assertRespon(expectValue, body);
        String assertContent = (assertResponseFlag) ? "Pass" : "Fail";
        System.out.print("assertContent:"+assertContent);
        Assert.assertEquals(assertContent, "Pass");
    }

    @DataProvider(name = "datas1")
    public Object[][] datas1() {
        //Object[m][n] m代表执行次数，n代表参数个数
        Object[][] datas = {
//                {1, "小睿伴学支付跳RAYS", "https://wechat50687.5rs.me/channelcenter/v1.0/accountSetting/getOpreateManageInfo?officialAccountsId=50687", "{\"errCode\":0,\"message\":\"操作成功！\",\"data\":{\"officialAccountsId\":50687,\"payAccounts\":23,\"officialAccountsName\":\"小睿伴学\",\"domain\":\"wechat50687.5rs.me\",\"payDomain\":\"weixin23.5rs.me\",\"manageDomain\":\"wechat22.5rs.me\",\"icon\":\"https://oss.5rs.me/oss/upload/image/jpg/bb8353c7cec744b99060ca3bf31b72f0.jpg\",\"description\":\"小睿伴学\",\"iosAlipayOpen\":0,\"payMchId\":\"1639325477\",\"currentPagePay\":0,\"phoneAuthOpen\":0,\"payMethod\":1,\"developerAppId\":\"wx180de5a9db184161\"}}"},
        };
        return datas;
    }


    public static void main(String[] args) {

    }

}
