package com.lemon.cases;

import io.qameta.allure.Description;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

import java.util.Arrays;

public class Rays7ServerCase extends BaseCase {

    @Test(dataProvider = "datas0")
    @Description("执行RAYS7服务")
    public void testManager(int id, String casename, String url, String json,String expectValue) throws Exception {
//        String token = "430f837c00f9978dffec9d4c0c05c751";
        // 创建post请求
        HttpPost post= new HttpPost(url);
        post.setHeader("Content-Type", "application/json");
        post.setEntity(new StringEntity(json));
        DefaultHttpClient client = new DefaultHttpClient();
        // 执行get请求，并使用response来存放执行后返回的响应内容
        HttpResponse response = client.execute(post);
        Header[] header = response.getAllHeaders(); // 响应头
        System.out.println("请求链接："+url);
        System.out.println("请求参数："+json);
        System.out.print("id:" + id + "\n"+ "casename:" + casename+ "\n");
        System.out.print("响应头信息:::" + Arrays.toString(header) + "\n");
        int status = response.getStatusLine().getStatusCode();
        System.out.print("状态码:::" + status + "\n");
        HttpEntity entity = response.getEntity(); // 响应体
        String body = EntityUtils.toString(entity);
        System.out.print("预期结果: " + expectValue+ "\n");
        System.out.print("响应结果: " + body+ "\n");
        Boolean assertResponseFlag = assertRespon(expectValue, body);
        String assertContent = (assertResponseFlag) ? "Pass" : "Fail";
        System.out.print("assertContent:"+assertContent);
        Assert.assertEquals(assertContent, "Pass");
    }

    @DataProvider(name = "datas0")
    public Object[][] datas0() {
        //Object[m][n] m代表执行次数，n代表参数个数
        Object[][] datas = {
                {0, "", "http://192.168.8.40:8270/aibrain/v1.0/digitalRange/testManager", "{\"event\":\"SDK_MSG_REPORT\",\"origin\":\"WECHAT_OFFICIAL\",\"wxSdkMsgDTO\":{\"content\":{\"textMsgDTO\":{\"content\":\"泛悦城\"}},\"contentType\":\"Text\",\"digitalPersonId\":1,\"msgId\":\"24123340480981103\",\"msgRemoteId\":\"24123340480981103\",\"sdkCode\":\"66059\",\"senderSdkCode\":\"o9vkPwnl1Nd4JdBDSpcujb4d4JsU\",\"userId\":182833195}}","{\"errCode\":0,\"message\":\"操作成功！\"}"}, // RAYS跳RAYS
        };
        return datas;
    }




}
