package com.lemon.cases;

import com.lemon.constants.Constants;
import com.lemon.pojo.API;
import com.lemon.pojo.Case;
import com.lemon.utils.AuthorizationUtils;
import com.lemon.utils.ExcelUtils;
import com.lemon.utils.SqlUtils;
import io.qameta.allure.Description;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

/**
 * @program: Lemon
 * @description:
 * @author: ray
 * @create: 2022-11-09 13:20
 **/
public class RaysDataCase extends BaseCase {

    @Test(dataProvider = "data2", description = "登录睿思数据")   // DTO数据传输
    @Description("登录睿思数据")
    public void testAAAAALogin(API api, Case cas) throws Exception {
        //1、参数化替换
        String params = replace(cas.getParams());
        String sql = replace(cas.getCheckSQL());
        cas.setParams(params);
        cas.setCheckSQL(sql);
        //2、数据库前置查询结果（断言必须在接口执行前后都查询）
        Object beforeSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //3、调用接口
        String body = call(api, cas, false);
        // 3.1 将登录的token存储（仅限于登录接口特有）
        AuthorizationUtils.storeToken(body);
        System.out.println(AuthorizationUtils.env);
        //4、断言响应结果，Excel中预期响应数据与实际响应数据进行对比
        boolean assertResponseFlag = assertResponse(cas, body);
        //5、添加接口响应回写excel内容
        addWBD(Integer.parseInt(cas.getId()), Constants.ACTURL_WRITER_BACK_CELL_NUM, body);
        //6、数据库后置查询结果
        Object afterSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //7、数据库断言
//        boolean sqlFlag = sqlAssert(cas, beforeSqlResult, afterSqlResult);
//        System.out.println("数据库断言结果：" + sqlFlag);
        //8、添加断言回写内容
//        String assertContent = (assertResponseFlag) ? "Pass" : "Fail";
//        addWBD(Integer.parseInt(cas.getId()), Constants.ASSERT_RESULT_CELL_NUM, assertContent);
        //9、添加日志
        //10、报表断言
//        Assert.assertEquals(assertContent, "Pass");
    }

    // 使用Excel文件传输接口信息和请求信息
    @DataProvider(name = "data2")
    public Object[][] data2() {
        Object[][] data = ExcelUtils.getAPIAndCaseByApiId("2");  // 传参apiID
        return data;
    }


    @Test(dataProvider = "data3", description = "获取用户信息")   // DTO数据传输
    @Description("获取用户信息")
    public void testGetLoginInfo(API api, Case cas) throws Exception {
        //1、参数化替换
        String params = replace(cas.getParams());
        String sql = replace(cas.getCheckSQL());
        cas.setParams(params);
        cas.setCheckSQL(sql);
        //2、数据库前置查询结果（断言必须在接口执行前后都查询）
        Object beforeSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //3、调用接口，需要看接口是否传递token
        String body = call(api, cas, true);
        //4、断言响应结果，Excel中预期响应数据与实际响应数据进行对比
        Boolean assertResponseFlag = assertResponse(cas, body);
        //5、添加接口响应回写excel内容
        addWBD(Integer.parseInt(cas.getId()), Constants.ACTURL_WRITER_BACK_CELL_NUM, body);
        //6、数据库后置查询结果
        Object afterSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //7、数据库断言
//        boolean sqlFlag = sqlAssert(cas, beforeSqlResult, afterSqlResult);
//        System.out.println("数据库断言结果：" + sqlFlag);
        //8、添加断言回写内容
        String assertContent = (assertResponseFlag) ? "Pass" : "Fail";
        addWBD(Integer.parseInt(cas.getId()), Constants.ASSERT_RESULT_CELL_NUM, assertContent);
        //9、添加日志
        //10、报表断言
        Assert.assertEquals(assertContent, "Pass");
    }

    // 使用Excel文件传输接口信息和请求信息
    @DataProvider(name = "data3")
    public Object[][] data3() {
        Object[][] data = ExcelUtils.getAPIAndCaseByApiId("3");   // 传参apiID
        return data;
    }


    @Test(dataProvider = "data4", description = "获取我订阅的未发期货")   // DTO数据传输
    @Description("获取我订阅的未发期货")
    public void testGetSubscriptList(API api, Case cas) throws Exception {
        //1、参数化替换
        String params = replace(cas.getParams());
        String sql = replace(cas.getCheckSQL());
        cas.setParams(params);
        cas.setCheckSQL(sql);
        //2、数据库前置查询结果（断言必须在接口执行前后都查询）
        Object beforeSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //3、调用接口，需要看接口是否传递token
        String body = call(api, cas, true);
        //4、断言响应结果，Excel中预期响应数据与实际响应数据进行对比
        Boolean assertResponseFlag = assertResponse(cas, body);
        //5、添加接口响应回写excel内容
        addWBD(Integer.parseInt(cas.getId()), Constants.ACTURL_WRITER_BACK_CELL_NUM, body);
        //6、数据库后置查询结果
        Object afterSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //7、数据库断言
        //8、添加断言回写内容
        //9、添加日志
        //10、报表断言
    }

    // 使用Excel文件传输接口信息和请求信息
    @DataProvider(name = "data4")
    public Object[][] data4() {
        Object[][] data = ExcelUtils.getAPIAndCaseByApiId("4");  // 传参apiID
        return data;
    }

    @Test(dataProvider = "data5", description = "获取我订阅的未发期货")   // DTO数据传输
    @Description("获取我订阅的未发期货")
    public void testGetSubscriptList2(API api, Case cas) throws Exception {
        //1、参数化替换
        String params = replace(cas.getParams());
        String sql = replace(cas.getCheckSQL());
        cas.setParams(params);
        cas.setCheckSQL(sql);
        //2、数据库前置查询结果（断言必须在接口执行前后都查询）
        Object beforeSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //3、调用接口，需要看接口是否传递token
        String body = call(api, cas, true);
        //4、断言响应结果，Excel中预期响应数据与实际响应数据进行对比
        Boolean assertResponseFlag = assertResponse(cas, body);
        //5、添加接口响应回写excel内容
        addWBD(Integer.parseInt(cas.getId()), Constants.ACTURL_WRITER_BACK_CELL_NUM, body);
        //6、数据库后置查询结果
        Object afterSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //7、数据库断言
        //8、添加断言回写内容
        //9、添加日志
        //10、报表断言
    }

    // 使用Excel文件传输接口信息和请求信息
    @DataProvider(name = "data5")
    public Object[][] data5() {
        Object[][] data = ExcelUtils.getAPIAndCaseByApiId("5");  // 传参apiID
        return data;
    }


    @Test(dataProvider = "data6", description = "获取我订阅的选题")   // DTO数据传输
    @Description("获取我订阅的选题")
    public void testGetSubscriptList3(API api, Case cas) throws Exception {
        //1、参数化替换
        String params = replace(cas.getParams());
        String sql = replace(cas.getCheckSQL());
        cas.setParams(params);
        cas.setCheckSQL(sql);
        //2、数据库前置查询结果（断言必须在接口执行前后都查询）
        Object beforeSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //3、调用接口，需要看接口是否传递token
        String body = call(api, cas, true);
        //4、断言响应结果，Excel中预期响应数据与实际响应数据进行对比
        Boolean assertResponseFlag = assertResponse(cas, body);
        //5、添加接口响应回写excel内容
        addWBD(Integer.parseInt(cas.getId()), Constants.ACTURL_WRITER_BACK_CELL_NUM, body);
        //6、数据库后置查询结果
        Object afterSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //7、数据库断言
        //8、添加断言回写内容
        //9、添加日志
        //10、报表断言
    }

    // 使用Excel文件传输接口信息和请求信息
    @DataProvider(name = "data6")
    public Object[][] data6() {
        Object[][] data = ExcelUtils.getAPIAndCaseByApiId("6");  // 传参apiID
        return data;
    }


    @Test(dataProvider = "data7", description = "获取我的主页")   // DTO数据传输
    @Description("获取我的主页")
    public void testGetHomePageTopicWarn(API api, Case cas) throws Exception {
        //1、参数化替换
        String params = replace(cas.getParams());
        String sql = replace(cas.getCheckSQL());
        cas.setParams(params);
        cas.setCheckSQL(sql);
        //2、数据库前置查询结果（断言必须在接口执行前后都查询）
        Object beforeSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //3、调用接口，需要看接口是否传递token
        String body = call(api, cas, true);
        //4、断言响应结果，Excel中预期响应数据与实际响应数据进行对比
        Boolean assertResponseFlag = assertResponse(cas, body);
        //5、添加接口响应回写excel内容
        addWBD(Integer.parseInt(cas.getId()), Constants.ACTURL_WRITER_BACK_CELL_NUM, body);
        //6、数据库后置查询结果
        Object afterSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //7、数据库断言
        //8、添加断言回写内容
        //9、添加日志
        //10、报表断言
    }

    // 使用Excel文件传输接口信息和请求信息
    @DataProvider(name = "data7")
    public Object[][] data7() {
        Object[][] data = ExcelUtils.getAPIAndCaseByApiId("7");  // 传参apiID
        return data;
    }


    @Test(dataProvider = "data8", description = "获取我的主页1")   // DTO数据传输
    @Description("获取我的主页1")
    public void testGetHomePageTopicChart(API api, Case cas) throws Exception {
        //1、参数化替换
        String params = replace(cas.getParams());
        String sql = replace(cas.getCheckSQL());
        cas.setParams(params);
        cas.setCheckSQL(sql);
        //2、数据库前置查询结果（断言必须在接口执行前后都查询）
        Object beforeSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //3、调用接口，需要看接口是否传递token
        String body = call(api, cas, true);
        //4、断言响应结果，Excel中预期响应数据与实际响应数据进行对比
        Boolean assertResponseFlag = assertResponse(cas, body);
        //5、添加接口响应回写excel内容
        addWBD(Integer.parseInt(cas.getId()), Constants.ACTURL_WRITER_BACK_CELL_NUM, body);
        //6、数据库后置查询结果
        Object afterSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //7、数据库断言
        //8、添加断言回写内容
        //9、添加日志
        //10、报表断言
    }

    // 使用Excel文件传输接口信息和请求信息
    @DataProvider(name = "data8")
    public Object[][] data8() {
        Object[][] data = ExcelUtils.getAPIAndCaseByApiId("8"); // 传参apiID
        return data;
    }


    @Test(dataProvider = "data9", description = "获取我的主页3")   // DTO数据传输
    @Description("获取我的主页3")
    public void testGetHomePageTopicWarn1(API api, Case cas) throws Exception {
        //1、参数化替换
        String params = replace(cas.getParams());
        String sql = replace(cas.getCheckSQL());
        cas.setParams(params);
        cas.setCheckSQL(sql);
        //2、数据库前置查询结果（断言必须在接口执行前后都查询）
        Object beforeSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //3、调用接口，需要看接口是否传递token
        String body = call(api, cas, true);
        //4、断言响应结果，Excel中预期响应数据与实际响应数据进行对比
        Boolean assertResponseFlag = assertResponse(cas, body);
        //5、添加接口响应回写excel内容
        addWBD(Integer.parseInt(cas.getId()), Constants.ACTURL_WRITER_BACK_CELL_NUM, body);
        //6、数据库后置查询结果
        Object afterSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //7、数据库断言
        //8、添加断言回写内容
        //9、添加日志
        //10、报表断言
    }

    // 使用Excel文件传输接口信息和请求信息
    @DataProvider(name = "data9")
    public Object[][] data9() {
        Object[][] data = ExcelUtils.getAPIAndCaseByApiId("9");  // 传参apiID
        return data;
    }


    @Test(dataProvider = "data10", description = "获取主页图书数据")   // DTO数据传输
    @Description("获取主页图书数据")
    public void testGetHomePageBookStatis(API api, Case cas) throws Exception {
        //1、参数化替换
        String params = replace(cas.getParams());
        String sql = replace(cas.getCheckSQL());
        cas.setParams(params);
        cas.setCheckSQL(sql);
        //2、数据库前置查询结果（断言必须在接口执行前后都查询）
        Object beforeSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //3、调用接口，需要看接口是否传递token
        String body = call(api, cas, true);
        //4、断言响应结果，Excel中预期响应数据与实际响应数据进行对比
        Boolean assertResponseFlag = assertResponse(cas, body);
        //5、添加接口响应回写excel内容
        addWBD(Integer.parseInt(cas.getId()), Constants.ACTURL_WRITER_BACK_CELL_NUM, body);
        //6、数据库后置查询结果
        Object afterSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //7、数据库断言
        //8、添加断言回写内容
        //9、添加日志
        //10、报表断言
    }

    // 使用Excel文件传输接口信息和请求信息
    @DataProvider(name = "data10")
    public Object[][] data10() {
        Object[][] data = ExcelUtils.getAPIAndCaseByApiId("10");   // 传参apiID
        return data;
    }

    @Test(dataProvider = "data11", description = "获取主页图书数据1")   // DTO数据传输
    @Description("获取主页图书数据1")
    public void testGetHomePageBookSalesChart(API api, Case cas) throws Exception {
        //1、参数化替换
        String params = replace(cas.getParams());
        String sql = replace(cas.getCheckSQL());
        cas.setParams(params);
        cas.setCheckSQL(sql);
        //2、数据库前置查询结果（断言必须在接口执行前后都查询）
        Object beforeSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //3、调用接口，需要看接口是否传递token
        String body = call(api, cas, true);
        //4、断言响应结果，Excel中预期响应数据与实际响应数据进行对比
        Boolean assertResponseFlag = assertResponse(cas, body);
        //5、添加接口响应回写excel内容
        addWBD(Integer.parseInt(cas.getId()), Constants.ACTURL_WRITER_BACK_CELL_NUM, body);
        //6、数据库后置查询结果
        Object afterSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //7、数据库断言
        //8、添加断言回写内容
        //9、添加日志
        //10、报表断言
    }

    // 使用Excel文件传输接口信息和请求信息
    @DataProvider(name = "data11")
    public Object[][] data11() {
        Object[][] data = ExcelUtils.getAPIAndCaseByApiId("11");  // 传参apiID
        return data;
    }


    @Test(dataProvider = "data12", description = "获取主页图书数据1")   // DTO数据传输
    @Description("获取主页图书数据1")
    public void testGetHomePageBookCommentChart(API api, Case cas) throws Exception {
        //1、参数化替换
        String params = replace(cas.getParams());
        String sql = replace(cas.getCheckSQL());
        cas.setParams(params);
        cas.setCheckSQL(sql);
        //2、数据库前置查询结果（断言必须在接口执行前后都查询）
        Object beforeSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //3、调用接口，需要看接口是否传递token
        String body = call(api, cas, true);
        //4、断言响应结果，Excel中预期响应数据与实际响应数据进行对比
        Boolean assertResponseFlag = assertResponse(cas, body);
        //5、添加接口响应回写excel内容
        addWBD(Integer.parseInt(cas.getId()), Constants.ACTURL_WRITER_BACK_CELL_NUM, body);
        //6、数据库后置查询结果
        Object afterSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //7、数据库断言
        //8、添加断言回写内容
        //9、添加日志
        //10、报表断言
    }

    // 使用Excel文件传输接口信息和请求信息
    @DataProvider(name = "data12")
    public Object[][] data12() {
        Object[][] data = ExcelUtils.getAPIAndCaseByApiId("12");  // 传参apiID
        return data;
    }


    @Test(dataProvider = "data13", description = "获取主页图书数据1")   // DTO数据传输
    @Description("获取主页图书数据1")
    public void testGetCategoryInfoList(API api, Case cas) throws Exception {
        //1、参数化替换
        String params = replace(cas.getParams());
        String sql = replace(cas.getCheckSQL());
        cas.setParams(params);
        cas.setCheckSQL(sql);
        //2、数据库前置查询结果（断言必须在接口执行前后都查询）
        Object beforeSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //3、调用接口，需要看接口是否传递token
        String body = call(api, cas, true);
        //4、断言响应结果，Excel中预期响应数据与实际响应数据进行对比
        Boolean assertResponseFlag = assertResponse(cas, body);
        //5、添加接口响应回写excel内容
        addWBD(Integer.parseInt(cas.getId()), Constants.ACTURL_WRITER_BACK_CELL_NUM, body);
        //6、数据库后置查询结果
        Object afterSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //7、数据库断言
        //8、添加断言回写内容
        //9、添加日志
        //10、报表断言
    }

    // 使用Excel文件传输接口信息和请求信息
    @DataProvider(name = "data13")
    public Object[][] data13() {
        Object[][] data = ExcelUtils.getAPIAndCaseByApiId("13");   // 传参apiID
        return data;
    }


    @Test(dataProvider = "data14", description = "获取主页图书数据1")   // DTO数据传输
    @Description("获取主页图书数据1")
    public void testGetLatestRecordList(API api, Case cas) throws Exception {
        //1、参数化替换
        String params = replace(cas.getParams());
        String sql = replace(cas.getCheckSQL());
        cas.setParams(params);
        cas.setCheckSQL(sql);
        //2、数据库前置查询结果（断言必须在接口执行前后都查询）
        Object beforeSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //3、调用接口，需要看接口是否传递token
        String body = call(api, cas, true);
        //4、断言响应结果，Excel中预期响应数据与实际响应数据进行对比
        Boolean assertResponseFlag = assertResponse(cas, body);
        //5、添加接口响应回写excel内容
        addWBD(Integer.parseInt(cas.getId()), Constants.ACTURL_WRITER_BACK_CELL_NUM, body);
        //6、数据库后置查询结果
        Object afterSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //7、数据库断言
        //8、添加断言回写内容
        //9、添加日志
        //10、报表断言
    }

    // 使用Excel文件传输接口信息和请求信息
    @DataProvider(name = "data14")
    public Object[][] data14() {
        Object[][] data = ExcelUtils.getAPIAndCaseByApiId("14");  // 传参apiID
        return data;
    }


    @Test(dataProvider = "data15", description = "获取主页图书数据1")   // DTO数据传输
    @Description("获取主页图书数据1")
    public void testGgetCategoryInfoList(API api, Case cas) throws Exception {
        //1、参数化替换
        String params = replace(cas.getParams());
        String sql = replace(cas.getCheckSQL());
        cas.setParams(params);
        cas.setCheckSQL(sql);
        //2、数据库前置查询结果（断言必须在接口执行前后都查询）
        Object beforeSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //3、调用接口，需要看接口是否传递token
        String body = call(api, cas, true);
        //4、断言响应结果，Excel中预期响应数据与实际响应数据进行对比
        Boolean assertResponseFlag = assertResponse(cas, body);
        //5、添加接口响应回写excel内容
        addWBD(Integer.parseInt(cas.getId()), Constants.ACTURL_WRITER_BACK_CELL_NUM, body);
        //6、数据库后置查询结果
        Object afterSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //7、数据库断言
        //8、添加断言回写内容
        //9、添加日志
        //10、报表断言
    }

    // 使用Excel文件传输接口信息和请求信息
    @DataProvider(name = "data15")
    public Object[][] data15() {
        Object[][] data = ExcelUtils.getAPIAndCaseByApiId("15"); // 传参apiID
        return data;
    }


    @Test(dataProvider = "data16", description = "【选题洞察】市场空白选题")   // DTO数据传输
    @Description("【选题洞察】市场空白选题")
    public void testListBlankTopic(API api, Case cas) throws Exception {
        //1、参数化替换
        String params = replace(cas.getParams());
        String sql = replace(cas.getCheckSQL());
        cas.setParams(params);
        cas.setCheckSQL(sql);
        //2、数据库前置查询结果（断言必须在接口执行前后都查询）
        Object beforeSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //3、调用接口，需要看接口是否传递token
        String body = call(api, cas, true);
        //4、断言响应结果，Excel中预期响应数据与实际响应数据进行对比
        Boolean assertResponseFlag = assertResponse(cas, body);
        //5、添加接口响应回写excel内容
        addWBD(Integer.parseInt(cas.getId()), Constants.ACTURL_WRITER_BACK_CELL_NUM, body);
        //6、数据库后置查询结果
        Object afterSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //7、数据库断言
        //8、添加断言回写内容
        //9、添加日志
        //10、报表断言
    }

    // 使用Excel文件传输接口信息和请求信息
    @DataProvider(name = "data16")
    public Object[][] data16() {
        Object[][] data = ExcelUtils.getAPIAndCaseByApiId("16");   // 传参apiID
        return data;
    }

    @Test(dataProvider = "data17", description = "【选题洞察】选题竞争态势")   // DTO数据传输
    @Description("【选题洞察】选题竞争态势")
    public void testGetCompeteTopicList(API api, Case cas) throws Exception {
        //1、参数化替换
        String params = replace(cas.getParams());
        String sql = replace(cas.getCheckSQL());
        cas.setParams(params);
        cas.setCheckSQL(sql);
        //2、数据库前置查询结果（断言必须在接口执行前后都查询）
        Object beforeSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //3、调用接口，需要看接口是否传递token
        String body = call(api, cas, true);
        //4、断言响应结果，Excel中预期响应数据与实际响应数据进行对比
        Boolean assertResponseFlag = assertResponse(cas, body);
        //5、添加接口响应回写excel内容
        addWBD(Integer.parseInt(cas.getId()), Constants.ACTURL_WRITER_BACK_CELL_NUM, body);
        //6、数据库后置查询结果
        Object afterSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //7、数据库断言
        //8、添加断言回写内容
        //9、添加日志
        //10、报表断言
    }

    // 使用Excel文件传输接口信息和请求信息
    @DataProvider(name = "data17")
    public Object[][] data17() {
        Object[][] data = ExcelUtils.getAPIAndCaseByApiId("17");    // 传参apiID
        return data;
    }


    @Test(dataProvider = "data18", description = "【选题洞察】潜力增长选题")   // DTO数据传输
    @Description("【选题洞察】潜力增长选题")
    public void testListHeatTopic4Report(API api, Case cas) throws Exception {
        //1、参数化替换
        String params = replace(cas.getParams());
        String sql = replace(cas.getCheckSQL());
        cas.setParams(params);
        cas.setCheckSQL(sql);
        //2、数据库前置查询结果（断言必须在接口执行前后都查询）
        Object beforeSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //3、调用接口，需要看接口是否传递token
        String body = call(api, cas, true);
        //4、断言响应结果，Excel中预期响应数据与实际响应数据进行对比
        Boolean assertResponseFlag = assertResponse(cas, body);
        //5、添加接口响应回写excel内容
        addWBD(Integer.parseInt(cas.getId()), Constants.ACTURL_WRITER_BACK_CELL_NUM, body);
        //6、数据库后置查询结果
        Object afterSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //7、数据库断言
        //8、添加断言回写内容
        //9、添加日志
        //10、报表断言
    }

    // 使用Excel文件传输接口信息和请求信息
    @DataProvider(name = "data18")
    public Object[][] data18() {
        Object[][] data = ExcelUtils.getAPIAndCaseByApiId("18");  // 传参apiID
        return data;
    }

    @Test(dataProvider = "data19", description = "【选题洞察】潜力增长选题>新品贡献大")   // DTO数据传输
    @Description("【选题洞察】潜力增长选题>新品贡献大")
    public void testListNewBookTopic4Report(API api, Case cas) throws Exception {
        //1、参数化替换
        String params = replace(cas.getParams());
        String sql = replace(cas.getCheckSQL());
        cas.setParams(params);
        cas.setCheckSQL(sql);
        //2、数据库前置查询结果（断言必须在接口执行前后都查询）
        Object beforeSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //3、调用接口，需要看接口是否传递token
        String body = call(api, cas, true);
        //4、断言响应结果，Excel中预期响应数据与实际响应数据进行对比
        Boolean assertResponseFlag = assertResponse(cas, body);
        //5、添加接口响应回写excel内容
        addWBD(Integer.parseInt(cas.getId()), Constants.ACTURL_WRITER_BACK_CELL_NUM, body);
        //6、数据库后置查询结果
        Object afterSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //7、数据库断言
        //8、添加断言回写内容
        //9、添加日志
        //10、报表断言
    }

    // 使用Excel文件传输接口信息和请求信息
    @DataProvider(name = "data19")
    public Object[][] data19() {
        Object[][] data = ExcelUtils.getAPIAndCaseByApiId("19");  // 传参apiID
        return data;
    }


    @Test(dataProvider = "data20", description = "【选题洞察】潜力增长选题>新品贡献大")   // DTO数据传输
    @Description("【选题洞察】潜力增长选题>新品贡献大")
    public void testListIncreaseTopic4Report(API api, Case cas) throws Exception {
        //1、参数化替换
        String params = replace(cas.getParams());
        String sql = replace(cas.getCheckSQL());
        cas.setParams(params);
        cas.setCheckSQL(sql);
        //2、数据库前置查询结果（断言必须在接口执行前后都查询）
        Object beforeSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //3、调用接口，需要看接口是否传递token
        String body = call(api, cas, true);
        //4、断言响应结果，Excel中预期响应数据与实际响应数据进行对比
        Boolean assertResponseFlag = assertResponse(cas, body);
        //5、添加接口响应回写excel内容
        addWBD(Integer.parseInt(cas.getId()), Constants.ACTURL_WRITER_BACK_CELL_NUM, body);
        //6、数据库后置查询结果
        Object afterSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //7、数据库断言
        //8、添加断言回写内容
        //9、添加日志
        //10、报表断言
    }

    // 使用Excel文件传输接口信息和请求信息
    @DataProvider(name = "data20")
    public Object[][] data20() {
        Object[][] data = ExcelUtils.getAPIAndCaseByApiId("20");  // 传参apiID
        return data;
    }

    @Test(dataProvider = "data21", description = "【本社分析】本社数据概览")   // DTO数据传输
    @Description("【本社分析】本社数据概览")
    public void testGetPublishCategoryStatis(API api, Case cas) throws Exception {
        //1、参数化替换
        String params = replace(cas.getParams());
        String sql = replace(cas.getCheckSQL());
        cas.setParams(params);
        cas.setCheckSQL(sql);
        //2、数据库前置查询结果（断言必须在接口执行前后都查询）
        Object beforeSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //3、调用接口，需要看接口是否传递token
        String body = call(api, cas, true);
        //4、断言响应结果，Excel中预期响应数据与实际响应数据进行对比
        Boolean assertResponseFlag = assertResponse(cas, body);
        //5、添加接口响应回写excel内容
        addWBD(Integer.parseInt(cas.getId()), Constants.ACTURL_WRITER_BACK_CELL_NUM, body);
        //6、数据库后置查询结果
        Object afterSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //7、数据库断言
        //8、添加断言回写内容
        //9、添加日志
        //10、报表断言
    }

    // 使用Excel文件传输接口信息和请求信息
    @DataProvider(name = "data21")
    public Object[][] data21() {
        Object[][] data = ExcelUtils.getAPIAndCaseByApiId("21");  // 传参apiID
        return data;
    }


}
