package com.lemon.httpclient;

import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

import java.net.http.HttpClient;
import java.util.Arrays;

/**
 * @program: Lemon
 * @description:
 * @author: ray
 * @create: 2022-09-23 12:06
 **/
public class GetDemo {
    /*
     * 1、创建request请求
     * 2、选择请求方法method
     * 3、填写URL
     * 4、有参传参、有头加头
     * 5、点击发送按钮
     * 6、接收响应
     * 7、格式化响应内容（body、status、headers）
     */
    public static void main(String[] args) throws Exception {
        // 1、2、3步骤
        HttpGet httpGet = new HttpGet("http://api.lemonban.com/fetureloan/loans");
        // 4、有参传参、有头加头
        httpGet.addHeader("X-Lemonban-Media-Type", "lemonban.v1");
        // 5、点击发送按钮，模拟客户端发送请求
        CloseableHttpClient client = HttpClients.createDefault();
        //记录开始时间
        long startTime = System.currentTimeMillis();
        // 由客户端发出请求，6、接收响应
        CloseableHttpResponse response = client.execute(httpGet);
        //记录结束时间
        long endTime = System.currentTimeMillis();
        // 获取body
        HttpEntity entity = response.getEntity();
        // 获取状态码
        int statusCode = response.getStatusLine().getStatusCode();
        // 获取header
        Header[] headers = response.getAllHeaders();

        System.out.println(EntityUtils.toString(entity));
        System.out.println(statusCode);
        System.out.println(Arrays.toString(headers));
        System.out.println("接口响应时间(毫秒):" + (endTime - startTime));

    }
}
