package com.lemon.utils;

import com.alibaba.fastjson.JSONPath;
import com.lemon.cases.BaseCase;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpRequest;
import org.apache.log4j.Logger;

import java.util.HashMap;
import java.util.Map;

/**
 * @program: Lemon
 * @description: 鉴权类
 * @author: ray
 * @create: 2022-11-06 16:22
 **/
public class AuthorizationUtils {

    // 日志
    public static Logger log = Logger.getLogger(BaseCase.class);

    // 定义为静态，随着类加载而加载，模拟的一个环境变量
    public static final Map<String, String> env = new HashMap<>();

    public void env(Map<String, String> env) {
        log.info(env);
    }

    /**
     * 1、从接口响应中获取token信息
     * 2、把Token信息存储到环境变量中
     * 使用jsonpath:  fastjson 1.2.0之后的版本支持JSONPath。这是一个很强大的功能，可以在java框架中当作对象查询语言（OQL）来使用。
     *
     * @param response:
     */
    public static void storeToken(String response) {
//        Object token = JSONPath.read(response, "$.data.token");  // 出版端需要在按照路径获取token
        Object token = JSONPath.read(response, "$.data");  // 睿思数据需要在按照路径获取token
        // 如果Token不为空说明登录成功
        if (token != null) {
            //将Token存储到环境变量
            env.put("token", token.toString());
            // 如果Token不为空，那么获取用户ID并且存储
            Object memberId = JSONPath.read(response, "$data.id");
            if (memberId != null) {
                env.put("${member_id}", memberId.toString());
            }
        }
    }

    /**
     * 判断环境变量中是否存在Token值，如果存在的话，在发送请求时设置token
     *
     * @param request
     */
    public static void setTokenInRequest(HttpRequest request) {
        // 从环境变量中取出Token
        String token = env.get("token");
        System.out.println("===========获取环境变量env===========" + env);
        System.out.println("===========获取token===========" + token);
        // 判断如果token不为空
        if (StringUtils.isNotBlank(token)) {
            /**
             *将token设置到header中，Authorization的作用是当客户端访问受口令保护时，
             * 服务器端会发送401状态码和WWW-Authenticate响应头，要求客户机使用Authorization来应答。
             */
            request.setHeader("token", "" + token);
        }
    }


    public static void main(String[] args) {
        String json = "{\"errCode\":0,\"message\":\"操作成功！\",\"data\":{\"isSystem\":\"1\",\"isRemember\":1,\"phone\":\"15927555348\",\"isBind\":false,\"token\":\"1r81EMweG7eBNLnWr3RghFFtl9EX8jxY\"}}";
        // 精准搜索：按层级匹配
        Object read = JSONPath.read(json, "$.data.token");
        //模糊搜索：默认为数组，找到的是所有的多个匹配值
        Object read1 = JSONPath.read(json, "$..log_id");

        System.out.println(read);
    }

}
