package com.lemon.utils;

import com.lemon.constants.Constants;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

/**
 * @program: Lemon
 * @description:
 * @author: ray
 * @create: 2022-09-27 10:15
 **/
public class JDBCUtils {
    /*
     *  BeanHandler<Object>()  将查询结果的第一行封装成指定的数据类型
     *  BeanListHandler<Object>()  将查询结果的每一行封装成指定类型的List集合
     *  ScalarHandler<Long>()  用来获得聚合函数的值,返回类型是Object,用Number来接收比较好
     * */

    public static void main(String[] args) throws SQLException {
        //创建queryRunner对象
        QueryRunner runner = new QueryRunner();
        //调用查询方法，传入数据库连接、SQL语句、返回值类型
        Connection conn = JDBCUtils.getConnection();
        //
        String sql = "select count(*) from member where mobile_phone='13111111111'";
        // 查询操作，使用query
        Long result = runner.query(conn, sql, new ScalarHandler<Long>());
        System.out.println(result);


    }


    /*
     * 获取数据库连接
     * */
    public static Connection getConnection() {
        //定义数据库连接对象
        Connection conn = null;
        try {
            /*
             * 你导入的数据库驱动包：mysql
             * jdbc:mysql://api.lemonban.com:3306/fetureloan?useUnicode=true&characterEncoding=utf-8
             * jdbc:数据库名称://数据库IP:端口/数据库名称?参数
             * */
            conn = DriverManager.getConnection(Constants.JDBC_URL, Constants.JDBC_USERNAME, Constants.JDBC_PASSWORD);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return conn;
    }

    /**
     * 关闭数据库连接
     *
     * @param conn：传参为数据库连接对象
     */
    public static void close(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }
    }


}
